<?php
// Prevent direct access
if (!defined('ACCESS_ALLOWED')) {
    header('HTTP/1.0 403 Forbidden');
    exit;
}

// Get current page for active state highlighting
$current_page = basename($_SERVER['PHP_SELF']);
?>

<aside class="sidebar">
    <ul class="sidebar-menu">
        <li class="sidebar-item">
            <a href="dashboard.php" class="sidebar-link <?php echo $current_page == 'dashboard.php' ? 'active' : ''; ?>">
                <i class="material-icons">dashboard</i>
                <span>Dashboard</span>
            </a>
        </li>
        
        <?php if ($_SESSION['role'] == 'admin' || $_SESSION['role'] == 'accountant'): ?>
        <li class="sidebar-item">
            <a href="students.php" class="sidebar-link <?php echo $current_page == 'students.php' ? 'active' : ''; ?>">
                <i class="material-icons">people</i>
                <span>Students</span>
            </a>
        </li>
        
        <li class="sidebar-item">
            <a href="fees.php" class="sidebar-link <?php echo $current_page == 'fees.php' ? 'active' : ''; ?>">
                <i class="material-icons">payment</i>
                <span>Fees Management</span>
            </a>
        </li>
        
        <li class="sidebar-item">
            <a href="payments.php" class="sidebar-link <?php echo $current_page == 'payments.php' ? 'active' : ''; ?>">
                <i class="material-icons">account_balance_wallet</i>
                <span>Payments</span>
            </a>
        </li>
        
        <li class="sidebar-item">
            <a href="reports.php" class="sidebar-link <?php echo $current_page == 'reports.php' ? 'active' : ''; ?>">
                <i class="material-icons">bar_chart</i>
                <span>Reports</span>
            </a>
        </li>
        <?php endif; ?>
        
        <?php if ($_SESSION['role'] == 'admin'): ?>
        <li class="sidebar-item">
            <a href="settings.php" class="sidebar-link <?php echo $current_page == 'settings.php' ? 'active' : ''; ?>">
                <i class="material-icons">settings</i>
                <span>Settings</span>
            </a>
        </li>
        <?php endif; ?>
        
        <li class="sidebar-item">
            <a href="logout.php" class="sidebar-link">
                <i class="material-icons">logout</i>
                <span>Logout</span>
            </a>
        </li>
    </ul>
</aside>

<button class="menu-toggle" style="display: none;">
    <i class="material-icons">menu</i>
</button>

<script>
// Show menu toggle on mobile
if (window.innerWidth < 992) {
    document.querySelector('.menu-toggle').style.display = 'block';
}
</script>